#
# This script was written by Peter Van Eeckhoutte (c)
# http://www.corelan.be:8800
# Last modified: march 2009
#
# Tested on Nessus and openVAS
#
# ike-scan can be found at http://www.nta-monitor.com/tools/ike-scan/
#
# Change history
# ---------------
#
# Version 1.0.9 : fixed plugin family & reference to other ike-scan script
#
# Version 1.0.8 : added plugin_timeout (set to unlimited) and added reference to CVE-2002-1623  
#
# Version 1.0.7 : fixed typo in plugin family
#
# Version 1.0.6 : changed copyright statement, plugin family and cleaned up some code
#
# Version 1.0.5 : added some options based on openVAS script  ike-scan.nasl
# (Portions taken and merged from ike-scan.nasl from OpenVAS (c) Tim Brown and Vlatko Kosturjak, as authorized by Tim)
#
#
# Copyright
# ---------
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# This program is distributed WITHOUT ANY WARRANTY

if (! defined_func("get_preference") ) exit(0);

no_exec=0;

if(description)
{
  script_id(99999);
  script_version ("$Revision: 1.0.8 $");
  script_name(english: "Ike-scan (nasl-wrapper)");
  desc = "This plugin runs ike-scan to audit IPSec implementations. See the Advanced section to configure it. Note that this plugin will not scan for open ports. It will assume that the target host is running IKE/IPSec

The host that was scanned has been identifies as an IPSec/VPN device.
If this host is supposed to be a VPN device, make sure it is configured in a safe/secure manner.
Some tips :
- Don't use a PSK, use certificates instead. If you have to use a PSK, make sure it is very long and considered strong.
- Don't use MD5, use SHA-1 or better instead
- Don't use DES, use 3DES or AES (or better) instead
- Don't use Aggressive mode, but use main mode instead, as explained at CVE-2002-1623 

CVE search for 'ike' : http://www.securityspace.com/smysecure/search.html?searchstr=ike

Risk factor: High";

  script_description(english:desc);
  script_summary(english: "Performs IKE Scans (Main, Aggressive, Fingerprinting, PSK extraction, etc) using ike-scan");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"This script is Copyright (C) 2009 Peter Van Eeckhoutte - http://www.corelan.be:8800");
  family["english"] = "Service detection";
  script_family(english: family["english"]);
  script_timeout(0);
  script_add_preference(name:"Scan Mode", type:"radio", value:"Aggressive;Main");
  script_add_preference(name:"Retries",type:"entry",value:"2");
  script_add_preference(name:"Perform Backoff Fingerprinting (slow)", type:"checkbox",value:"yes");
  script_add_preference(name:"Transform attributes (slow)",type:"checkbox",value:"no");
  script_add_preference(name:"Encryption algorithms", type:"entry", value:"1,2,3,4,5,6,7/128,7/196,7/256,8");
  script_add_preference(name:"Hash algorithms", type:"entry", value:"1,2,3,4,5,6");
  script_add_preference(name:"Authentication methods", type:"entry", value:"1,2,3,4,5,6,7,8,64221,65001");
  script_add_preference(name:"Diffie-Hellman groups", type:"entry", value:"1,2,5,7,8,12,14");
  script_add_preference(name:"Try default transform set and variate auth methods",type:"checkbox",value:"no");
  script_add_preference(name:"Try custom transform",type:"checkbox",value:"no");
  script_add_preference(name:"Custom transform :",type:"entry",value:"5,2,1,2");
  script_add_preference(name:"Look for keysize lower than (bits)",type:"entry",value:"128");
  script_add_preference(name:"Extract PSK",type:"checkbox",value:"yes");
  script_add_preference(name:"Source port : UDP",type:"entry",value:"500");
  script_add_preference(name:"Destination port : UDP",type:"entry",value:"500");
  script_add_preference(name:"Restrict bandwidth",type:"entry",value:"56000");
  script_add_preference(name:"Only audit if destination port is open",type:"checkbox",value:"no");
  script_add_preference(name:"IKE lifetime (seconds) :",type:"entry",value:"28800");
  script_add_preference(name:"IKE lifesize (kbytes) :",type:"entry",value:"0");
  script_add_preference(name:"ID (Group Name) :",type:"entry",value:"");
  script_add_preference(name:"ID Type :",type:"entry",value:"");
  script_add_preference(name:"Custom vendor ID (comma separated hex values)",type:"entry",value:"");
  script_add_preference(name:"Enable NAT-Traversal",type:"checkbox",value:"no"); 
  script_add_preference(name:"Show scan output in report",type:"checkbox",value:"no");

  script_cve_id("CVE-2002-1623");

  if (NASL_LEVEL < 2181 || ! defined_func("get_preference"))
  {
	  set_kb_item(name: "/tmp/UnableToRun/999999", value: TRUE);
	  display("Script #60001 (ike-scan-wrapper.nasl) cannot run - upgrade libnasl\n");
	  exit(0); 
  }
  exit(0);
}

if ( ! defined_func("pread") || ! find_in_path("ike-scan") ) no_exec = 1;

function search_vendor(_resout, _dport)
{
  _vendorguess="";
  _vendorfound="0";
  _allresults=split(_resout);
   foreach _resline (_allresults)
   {
     if ("Implementation guess" >< _resline)
     {
        if ("UNKNOWN" >!< _resline)
        {
           _vendorguess=string(_vendorguess,_resline,"\n");
           _vendorfound="1";
        }
      }
   }
   if (_vendorguess != "")
   {
     security_warning(port:_dport,protocol:"udp",data:_vendorguess);
     display(string("\n  *** Vendor information found : ",_vendorguess));
   }
  return _vendorfound;
}


function on_exit()
{
}



encryptionalgorithmname["1"] = "DES";
encryptionalgorithmname["2"] = "IDEA";
encryptionalgorithmname["3"] = "Blowfish";
encryptionalgorithmname["4"] = "RC5";
encryptionalgorithmname["5"] = "3DES";
encryptionalgorithmname["6"] = "CAST";
encryptionalgorithmname["7/128"] = "AES-128";
encryptionalgorithmname["7/196"] = "AES-196";
encryptionalgorithmname["7/256"] = "AES-256";
encryptionalgorithmname["8"] = "Camellia";
hashalgorithmname["1"] = "MD5";
hashalgorithmname["2"] = "SHA1";
hashalgorithmname["3"] = "Tiger";
hashalgorithmname["4"] = "SHA2-256";
hashalgorithmname["5"] = "SHA2-384";
hashalgorithmname["6"] = "SHA2-512";
authenticationmethodname["1"] = "PSK";
authenticationmethodname["2"] = "DSS-Signature";
authenticationmethodname["3"] = "RSA-Signature";
authenticationmethodname["4"] = "RSA-Encryption";
authenticationmethodname["5"] = "Revised-RSA-Encryption";
authenticationmethodname["6"] = "ElGamel-Encryption";
authenticationmethodname["7"] = "Revised-ElGamel-Encryption";
authenticationmethodname["8"] = "ECDSA-Signature";
authenticationmethodname["64221"] = "Hybrid";
authenticationmethodname["65001"] = "XAUTH";
diffiehellmangroupname["1"] = "MODP-768";
diffiehellmangroupname["2"] = "MODP-1024";
diffiehellmangroupname["3"] = "EC2N-155";
diffiehellmangroupname["4"] = "EC2N-185";
diffiehellmangroupname["5"] = "MODP-1536";
diffiehellmangroupname["6"] = "EC2N-163";
diffiehellmangroupname["7"] = "EC2N-163";
diffiehellmangroupname["8"] = "EC2N-183";
diffiehellmangroupname["9"] = "EC2N-183";
diffiehellmangroupname["10"] = "EC2N-409";
diffiehellmangroupname["11"] = "EC2N-409";
diffiehellmangroupname["12"] = "EC2N-571";
diffiehellmangroupname["13"] = "EC2N-571";
diffiehellmangroupname["14"] = "MODP-2048";


display(string("\nInitiating IKE audit \n--------------------------------------\n"));


sport = script_get_preference("Source port : UDP");
dport = script_get_preference("Destination port : UDP");
dport=dport*1;

display(string("[+] Source port set to UDP ",sport,"\n"));
display(string("[+] Destination port set to UDP ",dport,"\n"));
  


forceopen=script_get_preference("Only audit if destination port is open");
if (forceopen == "yes")
{
  script_require_ports(dport);
}

minkeysize=script_get_preference("Look for keysize lower than (bits)");
minkeysize=minkeysize*1;


if (no_exec == 0)
{
  ########################Start nasl wrapper code####################
  ip = get_host_ip();
  esc_ip = ""; l = strlen(ip);
  for (i = 0; i < l; i ++) 
    if (ip[i] == '.') esc_ip = strcat(esc_ip, "\.");
    else esc_ip = strcat(esc_ip, ip[i]);
  
  display(string("[+] Target ip : ",ip,"\n"));

  i=0;
  y=0;
  prop=0;


  encalgoselection = script_get_preference("Encryption algorithms");
  hashselection = script_get_preference("Hash algorithms");
  authselection=script_get_preference("Authentication methods");
  dhgroupselection=script_get_preference("Diffie-Hellman groups");

  if (encalgoselection != "")
  {
    encryptionlist=split(encalgoselection, sep:",", keep:FALSE);
  }
  else
  {
    encryptionlist = make_list("1","2","3","4","5","7/128","7/192","7/256","8");
  }

  if (hashselection != "")
  {
     hashlist = split(hashselection, sep:",", keep:FALSE);
  }
  else
  {
     hashlist = make_list("1","2","4","5","6");
  }

  if (authselection != "")
  {
    authmethods = split(authselection, sep:",",keep:FALSE);
  }
  else
  {
    authmethods= make_list("1","3","4","5","6","7","8","64221","65001");
  }

  if (dhgroupselection != "")
  {
    dhgroups = split(dhgroupselection, sep:",",keep:FALSE);
  }
  else
  {
    dhgroups=make_list("1","2","5","7","8","12","14");
  }



  #bandwidth ?
  bw = script_get_preference("Restrict bandwidth");

  if (!((bw == "") || (bw == "56000")))
  {
     display(string("[+] Bandwidth restriction set to ",bw,"\n"));
     argv1[i++] = string("--bandwidth=",bw);
     argv2[y++] = string("--bandwidth=",bw);
  }


  #nat traversal ?
  natt = script_get_preference("Enable NAT-Traversal");
  if (natt == "yes")
  {
    display("[+] NAT Traversal enabled\n");
    argv1[i++] = "--nat-t";
    argv2[y++] = "--nat-t";
  }

  nrofretries=script_get_preference("Retries");
  display(string("[+] Nr of retries set to ",nrofretries,"\n"));
  argv1[i++] = string("--retry=",nrofretries);
  argv2[y++] = string("--retry=",nrofretries);

  cvidvalue=script_get_preference("Custom vendor ID (comma separated hex values)");

  if (cvidvalue != "" )
  {
    allvendorids=split(cvidvalue,sep:',',keep:0);
    foreach vidvalue (allvendorids)
    {
      display(string("[+] Sending vendor ID ",vidvalue,"\n"));
      argv1[i++]=string("--vendor=",vidvalue);
      argv2[y++]=string("--vendor=",vidvalue);
    }
  }

  #set sources and destination port

  argv1[i++] = "--sport=" + sport;
  argv1[i++] = "--dport=" + dport;
  argv2[y++] = "--sport=" + sport;
  argv2[y++] = "--dport=" + dport;
  
  #set lifetime
  ltimes = script_get_preference("IKE lifetime (seconds) :");
  lsizek = script_get_preference("IKE lifesize (kbytes) :");

  if (ltimes > 0)
  {
  argv1[i++] = "--lifetime=" + ltimes;
  argv2[y++] = "--lifetime=" + ltimes;
  }
  if (lsizek > 0)
  {
  argv1[i++] = "--lifesize=" + lsizek;
  argv2[y++] = "--lifesize=" + lsizek;
  }

  #enable pskcrack
  pskcrack = script_get_preference("Extract PSK");
  if (pskcrack == "yes")
  {
   display("[+] PSK Dump/Extract enabled\n");
   argv1[i++]="--pskcrack";
  }  

 scanmode = script_get_preference("Scan Mode");
 groupindexi=0;
 groupindexy=0;
 id=script_get_preference("ID (Group Name) :");
 if (scanmode == "Aggressive")
 {
        display("[+] IKE Aggressive mode scan enabled\n");
        argv1[i++]="-A";

        if (id != "")
        {
          #create placeholder for group name / ID
          display(string("[+] ID/Group Name(s) to try : ",id,"\n"));
          groupindexi=i;
          i++;
        }

        idtype=script_get_preference("ID Type :");
        if (idtype != "")
        {
          display(string("[+] ID Type specified : ",idtype,"\n"));
          argv1[i++]=string("--idtype=",idtype);
        }
 }


 if (scanmode == "Main")
 {
   display("[+] IKE Main mode scan enabled");
   argv2[y++]="-M";
 }


 gv = script_get_preference("Perform Backoff Fingerprinting (slow)");
 backoffindexi=i;
 backoffindexy=y;
 if (gv == "yes")
 {
   display("[+] Backoff fingerprinting enabled\n");
   argv1[i++]= "--showbackoff";
   argv2[y++]= "--showbackoff";
 }

 #add multiline argument
  argv1[i++] = "--multiline";
  argv2[y++] = "--multiline";

  tr = script_get_preference("Transform attributes (slow)");
  authtr=script_get_preference("Try default transform set and variate auth methods");
  customtr=script_get_preference("Try custom transform");
  customtrvalue=script_get_preference("Custom transform :");
  if (customtrvalue == "")
  {
    customtr="no";
  } 
  tindexi=0;
  tindexy=0;
  #tr="yes";
  if (tr == "yes")
  {
    display("[+] Transform attributes enabled (scan will be slow, please wait)\n");
    tindexi=i;
    tindexy=y;
    #placeholder for transform arguments
    argv1[i++]="";
    argv2[y++]="";
  }
 
  #add IP to arguments
  argv1[i++] = ip;
  argv2[y++] = ip;            


  ###########launch scans##################
  display(string("[+] Running ike-scan against ",ip,":",dport,"\n"));

  vpnreported=0;
  vendorreported="0";

  dport=dport*1;
  alloutput="";
  #################Scan in aggressive mode###################"
  if (scanmode == "Aggressive")
  {
   display(string("    -> Aggressive mode\n"));
   aggrresults="";

   #do we need to transform ?
   if (tr == "yes")
   {
    #create transform strings and add to parameter list of all other options
    transforms="";
    foreach enctype (encryptionlist)
    {
       foreach hashtype (hashlist)
       {
         foreach authmethod (authmethods)
         {
           foreach dhgroup (dhgroups)
           {
             transforms=string("--trans=",enctype,",",hashtype,",",authmethod,",",dhgroup);
             argv1[tindexi]=transforms;

             if (id != "")
             {
                foreach groupname (split(id, sep:",",keep:FALSE))
                {
                  #testing group IDs as well    
                  groupid=string("--id=",groupname);
                  argv1[groupindexi]=groupid;
                  res = pread(cmd:"ike-scan",argv: argv1, cd: 1);
                  alloutput=string(alloutput,"\n",res);
                  if ((!("NO-PROPOSAL-CHOSEN" >< res)) && (!("0 returned handshake" >< res)))
                  {
                   display(string("       Host responded to handshake/proposal ",transforms," and group ID ",groupname," : \n",res,"\n"));
                   aggrresults=string(aggrresults,"\n","Transform : ",transforms,"\n","Group ID : ",groupname,"\n",res,"\n\n");
                   if (("1 returned handshake" >< res) || ("NO-PROPOSAL-CHOSEN" >< res))
                   {
                     if (vpnreported==0)
                     {
                        vpnreported=1;
                        security_note(proto:"udp",port:dport,extra:"IPSec VPN endpoint detected (Aggressive Mode)");
                      }
                     if (vendorreported == "0")
                     {
                        vendorreported=search_vendor(_resout:res,_dport:port);
                     }
                     if (vendorreported != "0") 
                     {
                        #disable backoff for next run, we have already found the vendor
                        argv1[backoffindexi]="-R";
                     }
                   }
                  }
                }
             }
             else
             {
               #display(string("       Connecting with attribute transform parameter ",transforms,"\n"));
               if (id != "")
               {
                foreach groupname (split(id, sep:",",keep:FALSE))
                {
                  #testing group IDs as well
                  groupid=string("--id=",groupname);
                  argv1[groupindexi]=groupid;
                  res = pread(cmd: "ike-scan", argv: argv1, cd: 1);
                  alloutput=string(alloutput,"\n",res);
                  #if there was a connect
                  if ((!("NO-PROPOSAL-CHOSEN" >< res)) && (!("0 returned handshake" >< res)))
                  {
                   display(string("       Host responded to handshake/proposal ",transforms," and group ID ",groupname," : \n",res,"\n"));
                   aggrresults=string(aggrresults,"\n","Transform : ",transforms,"\n","Group ID : ",groupname,"\n",res,"\n\n");
                  }
                   if (("1 returned handshake" >< res) || ("NO-PROPOSAL-CHOSEN" >< res))
                   {
                     if (vpnreported==0)
                     {
                        vpnreported=1;
                        security_note(proto:"udp",port:dport,extra:"IPSec VPN endpoint detected (Aggressive Mode)");
                      }
                   if (vendorreported == "0")
                   {
                      vendorreported=search_vendor(_resout:res,_dport:dport);
                   }
                   if (vendorreported != "0")
                   {
                      #disable backoff for next run, we have already found the vendor
                      argv1[backoffindexi]="-R";
                   }
                   }

                }

               }
               else
               {
                  res = pread(cmd: "ike-scan", argv: argv1, cd: 1);
                  alloutput=string(alloutput,"\n",res);
                  #if there was a connect
                  if ((!("NO-PROPOSAL-CHOSEN" >< res)) && (!("0 returned handshake" >< res)))
                  {
                   display(string("       Host responded to handshake/proposal ",transforms," : \n",res,"\n"));
                   aggrresults=string(aggrresults,"\n","Transform : ",transforms,"\n",res,"\n\n");
                  }
                  if (("1 returned handshake" >< res) || ("NO-PROPOSAL-CHOSEN" >< res))
                  {
                     if (vpnreported==0)
                     {
                        vpnreported=1;
                        security_note(proto:"udp",port:dport,extra: "IPSec VPN endpoint detected (Aggressive Mode)");
                      }
                   if (vendorreported == "0")
                   {
                      vendorreported=search_vendor(_resout:res,_dport:dport);
                   }
                   if (vendorreported != "0")
                   {
                      #disable backoff for next run, we have already found the vendor
                      argv1[backoffindexi]="-R";
                   }
                  }
               }
             }
           }
         }
        }
     }
   } #end if transforms

   if (authtr == "yes")
   {
     foreach authmethod (authmethods)
     {
        if (id != "")
        {
          foreach groupname (split(id, sep:",",keep:FALSE))
          {
            #testing group IDs as well
            groupid=string("--id=",groupname);
            argv1[groupindexi]=groupid;
            transforms=string("--auth=",authmethod);
            argv1[tindexi]=transforms;
            #display(string("       Connecting with authentication method parameter ",transforms,"\n"));
            res = pread(cmd: "ike-scan", argv: argv1, cd: 1);
            alloutput=string(alloutput,"\n",res);
            #if there was a connect
            if ((!("NO-PROPOSAL-CHOSEN" >< res)) && (!("0 returned handshake" >< res)))
            {
             display(string("       Host responded to handshake/proposal ",transforms," and group ID ",groupname," : \n",res,"\n"));
             aggrresults=string(aggrresults,"\n","Transform : ",transforms,"\n","Group ID : ",groupname,"\n",res,"\n\n");
            }
            if (("1 returned handshake" >< res) || ("NO-PROPOSAL-CHOSEN" >< res))
            {
                     if (vpnreported==0)
                     {
                        vpnreported=1;
                        security_note(proto:"udp",port:dport,extra:"IPSec VPN endpoint detected (Aggressive Mode)");
                      }
                   if (vendorreported == "0")
                   {
                      vendorreported=search_vendor(_resout:res,_dport:dport);
                   } 
                   if (vendorreported != "0")
                   {  
                      #disable backoff for next run, we have already found the vendor
                      argv1[backoffindexi]="-R";
                   }
            }
          }
        }
        else
        {
          transforms=string("--auth=",authmethod);
          argv1[tindexi]=transforms;
          #display(string("       Connecting with authentication method parameter ",transforms,"\n"));
          res = pread(cmd: "ike-scan", argv: argv1, cd: 1);
          alloutput=string(alloutput,"\n",res);
          #if there was a connect
          if ((!("NO-PROPOSAL-CHOSEN" >< res)) && (!("0 returned handshake" >< res)))
          {
           display(string("       Host responded to handshake/proposal ",transforms," :\n",res,"\n"));
           aggrresults=string(aggrresults,"\n","Transform : ",transforms,"\n",res,"\n\n");
          }
          if (("1 returned handshake" >< res) || ("NO-PROPOSAL-CHOSEN" >< res))
          {
                     if (vpnreported==0)
                     {
                        vpnreported=1;
                        security_note(proto:"udp",port:dport,extra:"IPSec VPN endpoint detected (Aggressive Mode)");
                      }
                   if (vendorreported == "0")
                   {
                      vendorreported=search_vendor(_resout:res,_dport:dport);
                   } 
                   if (vendorreported != "0")
                   {  
                      #disable backoff for next run, we have already found the vendor
                      argv1[backoffindexi]="-R";
                   }
          }
        }
     }
   }

   if (customtr == "yes")
   {
     if (id != "")
     {
      foreach groupname (split(id, sep:",",keep:FALSE))
      {
        #testing group IDs as well
        groupid=string("--id=",groupname);
        argv1[groupindexi]=groupid;
        transforms=string("--trans=",customtrvalue);
        argv1[tindexi]=transforms;
        #display(string("       Connecting with custom transform parameter ",customtrvalue,"\n"));
        res = pread(cmd: "ike-scan", argv: argv1, cd: 1);
        alloutput=string(alloutput,"\n",res);
        #if there was a connect
        if ((!("NO-PROPOSAL-CHOSEN" >< res)) && (!("0 returned handshake" >< res)))
        {
           display(string("       Host responded to handshake/proposal ",transforms," and group ID ",groupname," : \n",res,"\n"));
           aggrresults=string(aggrresults,"\n","Transform : ",customtrvalue,"\n","Group ID : ",groupname,"\n",res,"\n\n");
        }
        if (("1 returned handshake" >< res) || ("NO-PROPOSAL-CHOSEN" >< res))
        {
                     if (vpnreported==0)
                     {
                        vpnreported=1;
                        security_note(proto:"udp",port:dport,extra:"IPSec VPN endpoint detected (Aggressive Mode)");
                      }
                   if (vendorreported == "0")
                   {
                      vendorreported=search_vendor(_resout:res,_dport:dport);
                   } 
                   if (vendorreported != "0")
                   {  
                      #disable backoff for next run, we have already found the vendor
                      argv1[backoffindexi]="-R";
                   }
         }
      }
     }
     else
     {
        transforms=string("--trans=",customtrvalue);
        argv1[tindexi]=transforms;
        #display(string("       Connecting with custom transform parameter ",customtrvalue,"\n"));
        res = pread(cmd: "ike-scan", argv: argv1, cd: 1);
        alloutput=string(alloutput,"\n",res);
        #if there was a connect
        if ((!("NO-PROPOSAL-CHOSEN" >< res)) && (!("0 returned handshake" >< res)))
        {
           display(string("       Host responded to handshake/proposal ",transforms," :\n",res,"\n"));
           aggrresults=string(aggrresults,"\n","Transform : ",customtrvalue,"\n",res,"\n\n");
        }
        if (("1 returned handshake" >< res) || ("NO-PROPOSAL-CHOSEN" >< res))
        {
                     if (vpnreported==0)
                     {
                        vpnreported=1;
                        security_note(proto:"udp",port:dport,extra:"IPSec VPN endpoint detected (Aggressive Mode)");
                      }
                   if (vendorreported == "0")
                   {
                      vendorreported=search_vendor(_resout:res,_dport:dport);
                   } 
                   if (vendorreported != "0")
                   {  
                      #disable backoff for next run, we have already found the vendor
                      argv1[backoffindexi]="-R";
                   }
        }
     }
   }

   #no transforms ?
   if ((tr != "yes") && (authtr != "yes") && (customtr != "yes")) 
   {
     if (id != "")
     {
       foreach groupname (split(id, sep:",",keep:FALSE))
       {
        #testing group IDs as well
        groupid=string("--id=",groupname);
        argv1[groupindexi]=groupid; 
        res = pread(cmd: "ike-scan", argv: argv1, cd: 1);
        alloutput=string(alloutput,"\n",res);
        #if there was a connect
        if ((!("NO-PROPOSAL-CHOSEN" >< res)) && (!("0 returned handshake" >< res)))
        {
         display(string("       Host responded to handshake/proposal with group ID ",groupname," : \n",res,"\n"));
         aggrresults=string(aggrresults,"\n","Group ID : ",groupname,"\n",res,"\n\n");
        }
        if (("1 returned handshake" >< res) || ("NO-PROPOSAL-CHOSEN" >< res))
        {
                     if (vpnreported==0)
                     {
                        vpnreported=1;
                        security_note(proto:"udp",port:dport,extra:"IPSec VPN endpoint detected (Aggressive Mode)");
                      }
                   if (vendorreported == "0")
                   {
                      vendorreported=search_vendor(_resout:res,_dport:dport);
                   } 
                   if (vendorreported != "0")
                   {  
                      #disable backoff for next run, we have already found the vendor
                      argv1[backoffindexi]="-R";
                   }
        }
       }
     }
     else
     {
        res = pread(cmd: "ike-scan", argv: argv1, cd: 1);
        alloutput=res;
        aggrresults=res;
        if ((!("NO-PROPOSAL-CHOSEN" >< res)) && (!("0 returned handshake" >< res)))
        {
         display(string("       Host responded to handshake/proposal : \n",res,"\n"));
         aggrresults=string(aggrresults,"\n",res,"\n\n");
        }
        if (("1 returned handshake" >< res) || ("NO-PROPOSAL-CHOSEN" >< res))
        {
                     if (vpnreported==0)
                     {
                        vpnreported=1;
                        security_note(proto:"udp",port:dport,extra:"IPSec VPN endpoint detected (Aggressive Mode)");
                      }
                   if (vendorreported == "0")
                   {
                      vendorreported=search_vendor(_resout:res,_dport:dport);
                   } 
                   if (vendorreported != "0")
                   {  
                      #disable backoff for next run, we have already found the vendor
                      argv1[backoffindexi]="-R";
                   }
        }
     }
    }
  
    report=string("IKE Scan Aggressive Mode :\n\n",aggrresults);
  }

  vpnreported=0;
  vendorreported="0";
 

  ####################Scan in Main Mode#################### 
  if (scanmode == "Main")
  {
   display(string("    -> Main mode\n"));
   aggrresults2="";
   #do we need to transform ?
   if (tr == "yes")
   {
    #create transform strings and add to parameter list of all other options
    transforms="";
    foreach enctype (encryptionlist)
    {
       foreach hashtype (hashlist)
       {
         foreach authmethod (authmethods)
         {
           foreach dhgroup (dhgroups)
           {
            transforms="--trans=" + enctype + "," + hashtype + "," + authmethod + "," + dhgroup;
            argv2[tindexy]=transforms;

                  #run scan
                  #display(string("       Connecting with attribute transform parameter ",transforms,"\n"));
                  res2 = pread(cmd: "ike-scan", argv: argv2, cd: 1);
                  alloutput=string(alloutput,"\n",res2);
                  if ((!("NO-PROPOSAL-CHOSEN" >< res2)) && (!("0 returned handshake" >< res2)))
                  {
                    display(string("       Host responded to handshake/proposal ",transforms," :\n",res2,"\n"));
                    aggrresults2=string(aggrresults2,"\n","Transform : ",transforms,"\n",res2,"\n\n");
                   }
                   if (("1 returned handshake" >< res2) || ("NO-PROPOSAL-CHOSEN" >< res2))
                   {
                     if (vpnreported==0)
                     {
                        vpnreported=1;
                        security_note(proto:"udp",port:dport,extra:"IPSec VPN endpoint detected (Main Mode)");
                      }
                      if (vendorreported == "0")
                      {
                        vendorreported=search_vendor(_resout:res2,_dport:dport);
                      }
                      if (vendorreported != "0")
                      {
                        #disable backoff for next run, we have already found the vendor
                        argv2[backoffindexy]="-R";
                       }
                     }

           } #end foreach dhgroup
         } #end foreach authmethod
       } #end foreach hashtype  
     } #end foreach enctype
    } #end if tr=yes


   if (authtr == "yes")
   {
     foreach authmethod (authmethods)
     {
        transforms=string("--auth=",authmethod);
        argv2[tindexy]=transforms;
        #display(string("       Connecting with authentication method parameter ",transforms,"\n"));
        res2 = pread(cmd: "ike-scan", argv: argv2, cd: 1);
        alloutput=string(alloutput,"\n",res2);
        #if there was a connect
        if ((!("NO-PROPOSAL-CHOSEN" >< res2)) && (!("0 returned handshake" >< res2)))
        {
           display(string("       Host responded to handshake/proposal ",transforms," :\n",res2,"\n"));
           aggrresults2=string(aggrresults2,"\n","Transform : ",transforms,"\n",res2,"\n\n");
        }
        if (("1 returned handshake" >< res2) || ("NO-PROPOSAL-CHOSEN" >< res2))
        {
                     if (vpnreported==0)
                     {
                        vpnreported=1;
                        security_note(proto:"udp",port:dport,extra:"IPSec VPN endpoint detected (Main Mode)");
                      }
                   if (vendorreported == "0")
                   {
                      vendorreported=search_vendor(_resout:res2,_dport:dport);
                   }
                   if (vendorreported != "0")
                   {
                      #disable backoff for next run, we have already found the vendor
                      argv2[backoffindexy]="-R";
                   }
        }
     }
   }

   if (customtr == "yes")
   {
     transforms=string("--trans=",customtrvalue);
     argv2[tindexy]=transforms;
     #display(string("       Connecting with custom transform parameter ",customtrvalue,"\n"));
     res2 = pread(cmd: "ike-scan", argv: argv2, cd: 1);
     alloutput=string(alloutput,"\n",res2);
     #if there was a connect
     if ((!("NO-PROPOSAL-CHOSEN" >< res2)) && (!("0 returned handshake" >< res2)))
     {
        display(string("       Host responded to handshake/proposal ",transforms," :\n",res2,"\n"));
        aggrresults2=string(aggrresults2,"\n","Transform : ",customtrvalue,"\n",res2,"\n\n");
     }
     if (("1 returned handshake" >< res2) || ("NO-PROPOSAL-CHOSEN" >< res2))
     {
                     if (vpnreported==0)
                     {
                        vpnreported=1;
                        security_note(proto:"udp",port:dport,extra:"IPSec VPN endpoint detected (Main Mode)");
                      }
                   if (vendorreported == "0")
                   {
                      vendorreported=search_vendor(_resout:res2,_dport:dport);
                   }
                   if (vendorreported != "0")
                   {
                      #disable backoff for next run, we have already found the vendor
                      argv2[backoffindexy]="-R";
                   }
     }
   }

   if ((tr != "yes") && (authtr != "yes") && (customtr != "yes"))
   {
   res2 = pread(cmd: "ike-scan", argv: argv2, cd: 1);
   aggrresults2=res2;
   }

  report2=string("IKE scan Main mode :\n\n",aggrresults2);
  alloutput=aggrresults2;
  }

  #################Evaluate results#############################


    #Could PSK be extracted ?
    pskkey="";
    thisproposal="";
    if ((pskcrack == "yes") && (scanmode == "Aggressive"))
    {

       lastline="";

       if ("IKE PSK parameters" >< alloutput)
       {
         psklines=split(alloutput);
         foreach pskline (psklines)
         {
            if ("SA=(" >< pskline)
            {
              thisproposal=pskline;
            }

            if ("IKE PSK parameters" >< lastline)
            {
             pskkey=string(pskkey,"\n\n","Proposal : ",thisproposal,"\nPSK : \n",pskline);
            }
            lastline=pskline;
          }

        }
        if (pskkey != "")
        {
         pskkeyalert=string("One or more Pre-Shared Key(s) could be extracted while performing a handshake in aggressive mode :\n",pskkey,"\n");
         security_hole(port:dport,protocol:"udp",data:pskkeyalert);
        }
     }


   #Weak hashing ?
   if ("Hash=MD5" >< alloutput)
   {
     hashalert=string("This host is configured to allow the use of a hashing algorithm that is not considered to be secure (MD5)\n");
     foreach resline (allresults)
     {
       if ("Hash=MD5" >< resline)
       {
         hashalert=string(hashalert,"\n",resline);
       }
     }
     security_hole(port:dport,protocol:"udp",data:hashalert);
     display(string(" ** Weak hashing algo found **\n",hashalert,"\n"));
   }

   #Weak encryption ?
   if ("Enc=DES" >< alloutput)
   {
     encalert=string("This host is configured to allow the use of a weak encryption algorithm (DES)\n");
     foreach resline (allresults)
     {
       if ("Enc=DES" >< resline)
       {
         encalert=string(encalert,"\n",resline);
       }
     }
     security_hole(port:dport,protocol:"udp",data:encalert);
     display(string(" ** Weak encryption algo found **\n",encalert,"\n"));
   }

   #DH Group 1 ?
   if ("group=1:modp" ><  alloutput)
   {
     dhalert=string("This host is configured to use a DH Group with a low number of bits (DH Group 1)\n");
     foreach resline (allresults)
      {
       if ("group=1:modp" >< resline)
       {
         dhalert=string(dhalert,"\n",resline);
       }
     }
     security_warning(port:dport,protocol:"udp",data:dhalert);
     display(string(" ** Weak DH Group found **\n",dhalert,"\n"));
   }

   #Auth=PSK ?
   if ("Auth=PSK" >< alloutput)
   {
     authalert=string("This host is configured to use a Pre-Shared Key for authentication");
     security_warning(port:dport,protocol:"udp",data:authalert);
     display(string(" ** PSK Authentication detected **\n",authalert,"\n"));
   }

   #Keylength < minkeysize ?
   keysizealert="";
   if ("KeyLength=" >< alloutput)
   {
     foreach resline (allresults)
     {
       if ("KeyLength=" >< resline)
       {
         saentries=split(resline,sep:' ',keep: 0);
         foreach saentry (saentries)
         {
            if ("KeyLength" >< saentry)
            {
              lastentry="";
              arrvaluesarr=split(saentry,sep:"=",keep: 0);
              arrvaluesarray=make_list(arrvaluesarr);
              foreach arrelement (arrvaluesarray)
              {
                if ((lastentry="KeyLength") && (arrelement != "KeyLength"))
                {
                   keysize=arrelement;
                   keysize=keysize*1;
                   if ((keysize < minkeysize))
                   {
                     keysizealertheader=string("This proposal is configured to use a keylength of ",keysize," bits, which is less than ",minkeysize," bits :\n\n");
                     keysizealert=string(keysizealert,"\n",keysizealertheader,resline,"\n");
                   }

                 }
                 lastentry=arrelement;
               }
             }
         }
       }
     }
   }
   if (keysizealert != "")
   {
      keysizealertmessage=string(keysizealert);
      security_hole(port:dport,protocol:"udp",data:keysizealertmessage);
      display(string(" ** Low keylength found **\n",keysizealert,"\n"));
   }

   #Get all proposals found
   proposalsfound="";
   allresults=split(alloutput);
   foreach propline (allresults)
   {
     if ("SA=(" >< propline)
     {
        proposalsfound=string(proposalsfound,"\n",propline);
        prop++;
     }
   }

  prop=prop*1;
  if (prop > 0)
  {
     propnote=string("Host responded to ",prop," proposals. You may have to review the list manually as there could be some duplicates in the list, based on the type of audits that were performed during this adit :\n\n",proposalsfound);
     security_note(port:dport,protocol:"udp",data:propnote);
     display(propnote);
  }
  else
  {
    if (scanmode == "Aggressive")
    {
       report=string(report,"\nNo handshakes/proposals found.\n");
    }
    if (scanmode == "Main")
    {
       report2=string(report,"\nNo handshakes/proposals found.\n");
    }
  }
  
  ###############################Report#########################

  showfullreport=script_get_preference("Show scan output in report");
  if (showfullreport == "yes")
  {
     if (alloutput)
     {
     #report full scan details
     fullreport=string("Full scan report:\n-----------------------\n",report,"\n\n",report2);
     security_note(port:dport,protocol:"udp",data:fullreport);
     }
  }
 
  #################################################################

 if (!res && !res2 )
 {
 display("Error running ikescan - no results \n");
 display("Arguments :\n");
 display(argv1,"\n");
 display(argv2,"\n\n");
 exit(0);	
 }

display(string("[+] IKE Audit against ",ip," completed\n"));


##########process output#############

}
if (no_exec == 1)
{
display("\nError launching scan: ike-scan not found in path !\n\n");
  exit(0);
}


